using System;

class Program
{
    static void Main()
    {
        // Ucitavanje dimenzija i elemenata matrice
        string[] dimensions = Console.ReadLine().Split();
        int N = int.Parse(dimensions[0]);
        int M = int.Parse(dimensions[1]);

        string[] submatrixDimensions = Console.ReadLine().Split();
        int K = int.Parse(submatrixDimensions[0]);
        int L = int.Parse(submatrixDimensions[1]);

        int[,] A = new int[N, M];

        // Provera dimenzija matrice i podmatrice
        if (K > N || L > M)
        {
            Console.WriteLine("Neispravne dimenzije podmatrice.");
            return;
        }

        for (int i = 0; i < N; i++)
        {
            string[] row = Console.ReadLine().Split();

            // Provera dimenzija reda matrice
            if (row.Length != M)
            {
                Console.WriteLine("Neispravan unos reda matrice.");
                return;
            }

            for (int j = 0; j < M; j++)
            {
                A[i, j] = int.Parse(row[j]);
            }
        }

        // Racunanje najvece moguce lepote
        long result = CalculateBeauty(A, N, M, K, L);

        // Ispis rezultata
        Console.WriteLine(result);
    }

    static long CalculateBeauty(int[,] matrix, int N, int M, int K, int L)
    {
        long maxBeauty = long.MinValue;

        for (int i = 0; i <= N - K; i++)
        {
            for (int j = 0; j <= M - L; j++)
            {
                long beautySum = 0;

                // Racunanje sume podmatrice (K x L) optimizovano
                for (int x = i; x < i + K; x++)
                {
                    for (int y = j; y < j + L; y++)
                    {
                        beautySum += matrix[x, y];
                    }
                }

                // Ažuriranje maxBeauty ako je trenutna beautySum veca
                maxBeauty = Math.Max(maxBeauty, beautySum);
            }
        }

        return maxBeauty;
    }
}